/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package ihm.iprinewsanalyzer;

import data.structures.thema.ThemaItem;

import proc.thema.Experiences;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.Timer;

import java.awt.Dimension;
import java.awt.Rectangle;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
/**
 *
 * @author Utilisateur
 */
public class TableCorpus extends JPanel implements Scrollable {

    private int[] id;
    private String[] titres;
    private String[] descriptions;
    private JLabel[] lTitres;
    private JLabel[][] pertinencesIndiv;
    private JLabel[] pertinences;
    private JComboBox[] manuel;
    private FenetrePrincipale parent;

    public TableCorpus(FenetrePrincipale parent, int taille,
            ThemaItem[] thematiquesPossibles) {
        this.parent = parent;
        id = new int[taille];
        titres = new String[taille];
        descriptions = new String[taille];
        lTitres = new JLabel[taille];
        manuel = new JComboBox[taille];
        pertinencesIndiv = new JLabel[taille][Experiences.getExperiences().length];
        setPreferredSize(new Dimension(550 + Experiences.getExperiences().length * 150,
                20 + taille * 17));
        setLayout(null);
        for (int i = 0; i < taille; i++) {
            lTitres[i] = new JLabel("");
            lTitres[i].setBorder(BorderFactory.createEtchedBorder());
            add(lTitres[i]);
            lTitres[i].setBounds(0, 20 + 17 * i, 400, 17);
            manuel[i] = new JComboBox(thematiquesPossibles);
            add(manuel[i]);
            manuel[i].setBounds(400, 20 + 17 * i, 150, 17);
            manuel[i].addActionListener(new ActionListener() {

                public void actionPerformed(ActionEvent ae) {
                    //prendsEnCompteBonnesThematiques();
                }
            });
            for (int j = 0; j < Experiences.getExperiences().length; j++) {
                pertinencesIndiv[i][j] = new JLabel("?", JLabel.CENTER);
                pertinencesIndiv[i][j].setBorder(BorderFactory.createEtchedBorder());
                add(pertinencesIndiv[i][j]);
                pertinencesIndiv[i][j].setBounds(550 + 34 * j, 20 + 17 * i, 34, 17);
            }
        }
        JLabel lTitre = new JLabel("Article", JLabel.CENTER);
        lTitre.setBounds(0, 0, 400, 20);
        add(lTitre);
        JButton bSave = new JButton("Sauvegarder");
        bSave.setBounds(400, 0, 150, 20);
        add(bSave);
        bSave.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                sauvegardeManuel();
            }
        });

        pertinences = new JLabel[Experiences.getExperiences().length];
        for (int i = 0; i < Experiences.getExperiences().length; i++) {
            pertinences[i] = new JLabel("100%", JLabel.CENTER);
            pertinences[i].setBounds(550 + 34 * i, 0, 34, 20);
            add(pertinences[i]);
        }
        Charte.formateAndFormateChildren(this);
        //prendsEnCompteBonnesThematiques();
    }

    public void setArticleAt(int numArticle, int id, String title, String description, ThemaItem thematique) {
        this.id[numArticle] = id;
        this.titres[numArticle] = title;
        this.descriptions[numArticle] = description;
        this.manuel[numArticle].setSelectedItem(thematique);
        lTitres[numArticle].setText("<html>" + title.substring(0, Math.min(title.length(), 60)) + (title.length()>60?"...":""));
        lTitres[numArticle].setToolTipText("<html><b><u>" + title + "</u></b><br/><i>" + formate(description));
    }

    private String formate(String s) {
        StringBuffer buffer = new StringBuffer(s);
        for (int i = 100; i < buffer.length(); i += 100) {
            int espace = buffer.indexOf(" ", i);
            if (espace != -1) {
                buffer = buffer.replace(espace, espace + 1, "<br/>");
            }
        }
        return buffer.toString();
    }

    public int getIdAt(int numArticle) {
        return id[numArticle];
    }

    public String getTitreAt(int numArticle) {
        return titres[numArticle];
    }

    public String getDescriptionAt(int numArticle) {
        return descriptions[numArticle];
    }

    public int getIdThematiqueAt(int numArticle) {
        return ((ThemaItem) (manuel[numArticle].getSelectedItem())).getConceptID();
    }

    /*public void setResultatExperienceAt(int numArticle, int numExperience, String resultat) {
        pertinencesIndiv[numArticle][numExperience].setText(resultat);
        prendsEnCompteBonnesThematiques();
    }*/

    public int getTaille() {
        return titres.length;
    }

    /*public double getPertinence(int experience) {
        int max = titres.length;
        int corrects = 0;
        for (int i = 0; i < max; i++) {
            if (thematiques[i][experience].isCorrect()) {
                corrects++;
            }
        }
        return 1.0 * corrects / max;
    }*/

    public void actualise() {
        for (int i = 0; i < pertinences.length; i++) {
            pertinences[i].setText((int) (100 * Experiences.getExperiences()[i].getPertinence()) + "%");
        }
        for (int i = 0; i < pertinencesIndiv.length; i++) {
            for(int j=0; j<Experiences.getExperiences().length; j++){
                pertinencesIndiv[i][j].setText(Experiences.getExperiences()[j].isPertinent(i)?"O":"-");
            }
        }
    }

    /*private void prendsEnCompteBonnesThematiques() {
        for (int i = 0; i < thematiques.length; i++) {
            for (int j = 0; j < thematiques[i].length; j++) {
                if (thematiques[i][j].getTexte().trim().equalsIgnoreCase(
                        ((String) (manuel[i].getSelectedItem())).trim())) {
                    thematiques[i][j].setCorrect(true);
                } else {
                    thematiques[i][j].setCorrect(false);
                }
            }
        }
        actualise();
    }*/

    private void sauvegardeManuel() {
        parent.sauvegardeManuel();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle arg0, int arg1, int arg2) {
        return 10 * 60;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle arg0, int arg1, int arg2) {
        return 60;
    }

    /*private class BoutonThematique extends JLabel {

        private String texte;
        private boolean correct = true;

        public BoutonThematique(String thematique) {
            super(thematique, JLabel.CENTER);
            this.texte = thematique;
            setText(texte);
            addMouseListener(new MouseAdapter() {

                public void mouseClicked(MouseEvent arg0) {
                    toggle();
                }
            });
        }

        public String getTexte() {
            return texte;
        }

        public void toggle() {
            correct = !correct;
            setText(texte);
            ((TableCorpus) getParent()).actualise();
        }

        public void setCorrect(boolean correct) {
            this.correct = correct;
            setText(texte);
        }

        public boolean isCorrect() {
            return correct;
        }

        @Override
        public void setText(String texte) {
            this.texte = texte;
            if (correct) {
                super.setText("<html>" + texte);
            } else {
                super.setText("<html><strike>" + texte);
            }
        }
    }*/
}
